% Copyright (c) 2013, Massachusetts Institute of Technology
% This program was presented in the book "Visual Psychophysics:
% From Laboratory to Theory" by Zhong-Lin Lu and Barbara Dosher.
% The book is available at http://mitpress.mit.edu/books/visual-psychophysics

%%% Program RegionOfInterest.m
[M,  map] = imread('Church.jpg',  'jpeg');          
M1 = rgb2gray(M);
mI = mean2(M1);
Sz = size(M);
[x,  y] = meshgrid(-Sz(2)/2:(Sz(2)/2-1),  ...
          Sz(1)/2:-1:-(Sz(1)/2-1));

% A circular window mask with radius s 
s = 400;
Gmask1 = ((x + 600).^2 + (y - 100).^2  <  s^2); 
         % center mask at (-600,+100)
M2 = uint8((double(M1) - mI).*Gmask1 + mI);
showImage(M2,   'grayscale');
 
% A Gaussian mask with standard deviation s
Gmask1 = exp(-((x + 600).^2 + (y - 100).^2)/2/s^2);
M3 = uint8((double(M1) - mI).*Gmask1 + mI);
showImage(M3,   'grayscale');
 
% AMD (age related macular degeneration example)
Gmask1 = 1 - exp(-((x + 600).^2 + (y - 100).^2)/2/s^2);
M4 = uint8((double(M1) - mI).*Gmask1 + mI);
showImage(M4,   'grayscale');
